/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2Test.common.enums;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;




/**
 * The Class CommonEnumTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class CommonEnumTest.
 * 
 *          Description: In this CommonEnumTest Class which extends the abstract
 *          class, AbstractMockMvcTests, junit tests are defined.
 */

public class CommonEnumTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(CommonEnumTest.class);

	/**
	 * Test common enum.
	 */
	@Test
	public void TestCommonEnum() {

		logger.info("**********Junit Test Common Enum**********");

		Assert.assertTrue(
				CommonEnum.NO_RECORD_FOUND.getText().toLowerCase().compareTo("No records found.".toLowerCase()) == 0);

		Assert.assertTrue(
				CommonEnum.REQUEST_ACCEPTED.getText().toLowerCase().compareTo("RequestAccepted".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_DENIED.getText().toLowerCase().compareTo("Denied".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_DRAFT.getText().toLowerCase().compareTo("Draft".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_RETURNED.getText().toLowerCase().compareTo("Returned".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_SENT.getText().toLowerCase().compareTo("Sent".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_SUBMIT.getText().toLowerCase().compareTo("Submitted".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_UPDATE.getText().toLowerCase().compareTo("Update".toLowerCase()) == 0);

		Assert.assertTrue(
				CommonEnum.RESULTS_ACCEPTED.getText().toLowerCase().compareTo("ResultsAccepted".toLowerCase()) == 0);

		Assert.assertTrue(
				CommonEnum.RESULTS_DELIVERED.getText().toLowerCase().compareTo("ResultsDelivered".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.RESULTS_NOT_ACCEPTED.getText().toLowerCase()
				.compareTo("ResultsNotAccepted".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.REQUEST_NOT_ACCEPTED.getText().toLowerCase()
				.compareTo("RequestNotAccepted".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.SPACE.getText().compareToIgnoreCase(" ") == 0);

		Assert.assertTrue(CommonEnum.UNABLE_TO_CREATE_REQUEST.getText().toLowerCase()
				.compareTo("Unable to create Request. Business process failed to start.".toLowerCase()) == 0);

		Assert.assertTrue(CommonEnum.UNABLE_TO_UPDATE_STUDY_APPROVAL.getText().toLowerCase()
				.compareTo("Unable to update Study Approval".toLowerCase()) == 0);

		Assert.assertTrue(
				CommonEnum.STATUS_DESC.getText().toLowerCase().compareTo("statusDescription".toLowerCase()) == 0);

		logger.info("**********End of Junit Test Common Enum**********");
	}

}
